/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm;

import java.time.Duration;
import java.time.LocalDateTime;
import net.sourceforge.plantuml.project.ngm.NGMAllocation;
import net.sourceforge.plantuml.project.ngm.NGMTask;
import net.sourceforge.plantuml.project.ngm.NGMTotalEffort;
import net.sourceforge.plantuml.project.ngm.math.LoadIntegrator;

public class NGMTaskFixedTotalEffort
extends NGMTask {
    private NGMTotalEffort totalEffort;
    private LocalDateTime start;
    private LocalDateTime end;

    public NGMTaskFixedTotalEffort(NGMAllocation allocation, NGMTotalEffort totalEffort) {
        super(allocation);
        this.totalEffort = totalEffort;
    }

    @Override
    public LocalDateTime getStart() {
        return this.start;
    }

    @Override
    public void setStart(LocalDateTime start) {
        this.start = start;
        this.end = new LoadIntegrator(this.allocation.getLoadFunction(), this.totalEffort).computeEnd(start);
    }

    @Override
    public LocalDateTime getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(LocalDateTime end) {
        this.end = end;
        this.start = new LoadIntegrator(this.allocation.getLoadFunction(), this.totalEffort).computeStart(end);
    }

    @Override
    public Duration getDuration() {
        return Duration.between(this.start, this.end);
    }

    @Override
    public NGMTotalEffort getTotalEffort() {
        return this.totalEffort;
    }
}

