/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr.match;

import ghidra.app.plugin.assembler.sleigh.expr.match.AbstractExpressionMatcher;
import ghidra.app.plugin.assembler.sleigh.expr.match.ExpressionMatcher;
import ghidra.app.plugin.processors.sleigh.expression.ConstantValue;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import java.util.Map;
import java.util.Set;

public class FieldSizeMatcher
extends AbstractExpressionMatcher<PatternValue> {
    protected final ExpressionMatcher<?> sizeMatcher;

    public FieldSizeMatcher(ExpressionMatcher<?> sizeMatcher) {
        super(Set.of(ContextField.class, TokenField.class));
        this.sizeMatcher = sizeMatcher;
    }

    @Override
    protected boolean matchDetails(PatternValue expression, Map<ExpressionMatcher<?>, PatternExpression> result) {
        if (expression instanceof ContextField) {
            ContextField cf = (ContextField)expression;
            long size = cf.getEndBit() - cf.getStartBit() + 1;
            return this.sizeMatcher.match(new ConstantValue(size), result);
        }
        if (expression instanceof TokenField) {
            TokenField tf = (TokenField)expression;
            long size = tf.getBitEnd() - tf.getBitStart() + 1;
            return this.sizeMatcher.match(new ConstantValue(size), result);
        }
        return false;
    }
}

