/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import ghidra.pty.ShellUtils;
import java.util.Map;

public class JdiArguments {
    private final Map<String, String> env;
    private final Mode mode;

    public JdiArguments(Map<String, String> env) {
        this.env = Map.copyOf(env);
        this.mode = this.computeMode();
    }

    protected Mode computeMode() {
        if (this.env.containsKey("OPT_PORT")) {
            return Mode.ATTACH_PORT;
        }
        if (this.env.containsKey("OPT_PID")) {
            return Mode.ATTACH_PID;
        }
        return Mode.LAUNCH;
    }

    protected AttachingConnector findConnectorByArgKey(VirtualMachineManager vmm, String key) {
        return vmm.attachingConnectors().stream().filter(ac -> ac.defaultArguments().containsKey(key)).findFirst().orElseThrow();
    }

    public Connector getConnector(VirtualMachineManager vmm) {
        return switch (this.mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.findConnectorByArgKey(vmm, "port");
            case 1 -> this.findConnectorByArgKey(vmm, "pid");
            case 2 -> vmm.defaultConnector();
        };
    }

    public void putArguments(Map<String, Connector.Argument> args) {
        switch (this.mode.ordinal()) {
            case 0: {
                args.get("hostname").setValue(this.env.get("OPT_HOST").toString());
                args.get("port").setValue(this.env.get("OPT_PORT").toString());
                args.get("timeout").setValue(this.env.get("OPT_TIMEOUT").toString());
                break;
            }
            case 1: {
                args.get("pid").setValue(this.env.get("OPT_PID").toString());
                args.get("timeout").setValue(this.env.get("OPT_TIMEOUT").toString());
                break;
            }
            case 2: {
                String cp;
                args.get("main").setValue(this.env.get("OPT_TARGET_CLASS"));
                Connector.Argument argSuspend = args.get("suspend");
                String optSuspend = this.env.get("OPT_SUSPEND");
                if (argSuspend != null && optSuspend != null) {
                    argSuspend.setValue(optSuspend);
                }
                Connector.Argument argIncludeVirtualThreads = args.get("includevirtualthreads");
                String optInclude = this.env.get("OPT_INCLUDE");
                if (argIncludeVirtualThreads != null && optInclude != null) {
                    argIncludeVirtualThreads.setValue(optInclude);
                }
                if ((cp = this.env.get("OPT_TARGET_CLASSPATH")).isBlank()) break;
                args.get("options").setValue("-cp " + ShellUtils.generateArgument((String)cp));
            }
        }
    }

    static enum Mode {
        ATTACH_PORT,
        ATTACH_PID,
        LAUNCH;

    }
}

