/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import sun.security.ssl.ProtocolVersion;

enum ContentType {
    INVALID(0, "invalid", ProtocolVersion.PROTOCOLS_OF_13),
    CHANGE_CIPHER_SPEC(20, "change_cipher_spec", ProtocolVersion.PROTOCOLS_TO_12),
    ALERT(21, "alert", ProtocolVersion.PROTOCOLS_TO_13),
    HANDSHAKE(22, "handshake", ProtocolVersion.PROTOCOLS_TO_13),
    APPLICATION_DATA(23, "application_data", ProtocolVersion.PROTOCOLS_TO_13);

    final byte id;
    final String name;
    final ProtocolVersion[] supportedProtocols;

    private ContentType(byte by, String string2, ProtocolVersion[] protocolVersionArray) {
        this.id = by;
        this.name = string2;
        this.supportedProtocols = protocolVersionArray;
    }

    static ContentType valueOf(byte by) {
        for (ContentType contentType : ContentType.values()) {
            if (contentType.id != by) continue;
            return contentType;
        }
        return null;
    }

    static String nameOf(byte by) {
        for (ContentType contentType : ContentType.values()) {
            if (contentType.id != by) continue;
            return contentType.name;
        }
        return "<UNKNOWN CONTENT TYPE: " + (by & 0xFF) + ">";
    }
}

