/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public enum GroupRoles {
    EXISTING_MEMBER,
    MEMBER,
    OWNER,
    ADMIN,
    EDITOR;

    public static final String SEPARATOR = ",";

    public static String encode(List<GroupRoles> roles) {
        String role = roles.stream().map(Enum::name).collect(Collectors.joining(SEPARATOR));
        return role;
    }

    public static List<GroupRoles> decode(String value) {
        String[] roleValues = value.split(SEPARATOR);
        return Arrays.stream(roleValues).map(GroupRoles::valueOf).collect(Collectors.toList());
    }

    public static boolean hasPermissions(@Nullable String role, GroupRoles ... roles) {
        HashSet requiredRoles;
        if (role == null) {
            return false;
        }
        HashSet userRoles = Sets.newHashSet(GroupRoles.decode(role));
        return !Sets.intersection((Set)userRoles, (Set)(requiredRoles = Sets.newHashSet(Arrays.asList(roles)))).isEmpty();
    }
}

