/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.cpdsadapter;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.cpdsadapter.PooledConnectionImpl;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class DriverAdapterCPDS
implements ConnectionPoolDataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final String KEY_MIN_EVICTABLE_IDLE_DURATION = "minEvictableIdleDuration";
    private static final String KEY_DURATION_BETWEEN_EVICTION_RUNS = "durationBetweenEvictionRuns";
    private static final String KEY_LOGIN_TIMEOUT = "loginTimeout";
    private static final String KEY_URL = "url";
    private static final String KEY_DRIVER = "driver";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED = "accessToUnderlyingConnectionAllowed";
    private static final String KEY_MAX_PREPARED_STATEMENTS = "maxPreparedStatements";
    private static final String KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS = "minEvictableIdleTimeMillis";
    private static final String KEY_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    private static final String KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS = "timeBetweenEvictionRunsMillis";
    private static final String KEY_MAX_IDLE = "maxIdle";
    private static final String KEY_POOL_PREPARED_STATEMENTS = "poolPreparedStatements";
    private static final long serialVersionUID = -4820523787212147844L;
    private static final String GET_CONNECTION_CALLED = "A PooledConnection was already requested from this source, further initialization is not allowed.";
    private String description;
    private String connectionString;
    private String userName;
    private char[] userPassword;
    private String driver;
    private int loginTimeout;
    private transient PrintWriter logWriter;
    private boolean poolPreparedStatements;
    private int maxIdle = 10;
    private Duration durationBetweenEvictionRuns = BaseObjectPoolConfig.DEFAULT_DURATION_BETWEEN_EVICTION_RUNS;
    private int numTestsPerEvictionRun = -1;
    private Duration minEvictableIdleDuration = BaseObjectPoolConfig.DEFAULT_MIN_EVICTABLE_IDLE_DURATION;
    private int maxPreparedStatements = -1;
    private volatile boolean getConnectionCalled;
    private Properties connectionProperties;
    private boolean accessToUnderlyingConnectionAllowed;

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    private boolean getBooleanContentString(RefAddr refAddr) {
        return Boolean.parseBoolean(this.getStringContent(refAddr));
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriver() {
        return this.driver;
    }

    public Duration getDurationBetweenEvictionRuns() {
        return this.durationBetweenEvictionRuns;
    }

    private int getIntegerStringContent(RefAddr refAddr) {
        return Integer.parseInt(this.getStringContent(refAddr));
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxPreparedStatements() {
        return this.maxPreparedStatements;
    }

    public Duration getMinEvictableIdleDuration() {
        return this.minEvictableIdleDuration;
    }

    @Deprecated
    public int getMinEvictableIdleTimeMillis() {
        return (int)this.minEvictableIdleDuration.toMillis();
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws ClassNotFoundException {
        Reference reference;
        DriverAdapterCPDS driverAdapterCPDS = null;
        if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(this.getClass().getName())) {
            RefAddr refAddr = reference.get(KEY_DESCRIPTION);
            if (this.isNotEmpty(refAddr)) {
                this.setDescription(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_DRIVER))) {
                this.setDriver(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_URL))) {
                this.setUrl(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("user"))) {
                this.setUser(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get("password"))) {
                this.setPassword(this.getStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_POOL_PREPARED_STATEMENTS))) {
                this.setPoolPreparedStatements(this.getBooleanContentString(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_MAX_IDLE))) {
                this.setMaxIdle(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS))) {
                this.setTimeBetweenEvictionRunsMillis(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_NUM_TESTS_PER_EVICTION_RUN))) {
                this.setNumTestsPerEvictionRun(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS))) {
                this.setMinEvictableIdleTimeMillis(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_MAX_PREPARED_STATEMENTS))) {
                this.setMaxPreparedStatements(this.getIntegerStringContent(refAddr));
            }
            if (this.isNotEmpty(refAddr = reference.get(KEY_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED))) {
                this.setAccessToUnderlyingConnectionAllowed(this.getBooleanContentString(refAddr));
            }
            driverAdapterCPDS = this;
        }
        return driverAdapterCPDS;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getPassword() {
        return Utils.toString(this.userPassword);
    }

    public char[] getPasswordCharArray() {
        return Utils.clone(this.userPassword);
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.getConnectionCalled = true;
        if (this.connectionProperties != null) {
            this.update(this.connectionProperties, "user", string);
            this.update(this.connectionProperties, "password", string2);
        }
        PooledConnectionImpl pooledConnectionImpl = null;
        try {
            pooledConnectionImpl = this.getPooledConnectionImpl(string, string2);
        }
        catch (ClassCircularityError classCircularityError) {
            pooledConnectionImpl = this.getPooledConnectionImpl(string, string2);
        }
        if (this.isPoolPreparedStatements()) {
            GenericKeyedObjectPoolConfig genericKeyedObjectPoolConfig = new GenericKeyedObjectPoolConfig();
            genericKeyedObjectPoolConfig.setMaxTotalPerKey(Integer.MAX_VALUE);
            genericKeyedObjectPoolConfig.setBlockWhenExhausted(false);
            genericKeyedObjectPoolConfig.setMaxWait(Duration.ZERO);
            genericKeyedObjectPoolConfig.setMaxIdlePerKey(this.getMaxIdle());
            if (this.getMaxPreparedStatements() <= 0) {
                genericKeyedObjectPoolConfig.setTimeBetweenEvictionRuns(this.getDurationBetweenEvictionRuns());
                genericKeyedObjectPoolConfig.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                genericKeyedObjectPoolConfig.setMinEvictableIdleDuration(this.getMinEvictableIdleDuration());
            } else {
                genericKeyedObjectPoolConfig.setMaxTotal(this.getMaxPreparedStatements());
                genericKeyedObjectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofMillis(-1L));
                genericKeyedObjectPoolConfig.setNumTestsPerEvictionRun(0);
                genericKeyedObjectPoolConfig.setMinEvictableIdleDuration(Duration.ZERO);
            }
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> genericKeyedObjectPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>(pooledConnectionImpl, genericKeyedObjectPoolConfig);
            pooledConnectionImpl.setStatementPool(genericKeyedObjectPool);
        }
        return pooledConnectionImpl;
    }

    private PooledConnectionImpl getPooledConnectionImpl(String string, String string2) throws SQLException {
        PooledConnectionImpl pooledConnectionImpl = this.connectionProperties != null ? new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), this.connectionProperties)) : new PooledConnectionImpl(DriverManager.getConnection(this.getUrl(), string, string2));
        pooledConnectionImpl.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pooledConnectionImpl;
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = this.getClass().getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr(KEY_DESCRIPTION, this.getDescription()));
        reference.add(new StringRefAddr(KEY_DRIVER, this.getDriver()));
        reference.add(new StringRefAddr(KEY_LOGIN_TIMEOUT, String.valueOf(this.getLoginTimeout())));
        reference.add(new StringRefAddr("password", this.getPassword()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr(KEY_URL, this.getUrl()));
        reference.add(new StringRefAddr(KEY_POOL_PREPARED_STATEMENTS, String.valueOf(this.isPoolPreparedStatements())));
        reference.add(new StringRefAddr(KEY_MAX_IDLE, String.valueOf(this.getMaxIdle())));
        reference.add(new StringRefAddr(KEY_NUM_TESTS_PER_EVICTION_RUN, String.valueOf(this.getNumTestsPerEvictionRun())));
        reference.add(new StringRefAddr(KEY_MAX_PREPARED_STATEMENTS, String.valueOf(this.getMaxPreparedStatements())));
        reference.add(new StringRefAddr(KEY_DURATION_BETWEEN_EVICTION_RUNS, String.valueOf(this.getDurationBetweenEvictionRuns())));
        reference.add(new StringRefAddr(KEY_TIME_BETWEEN_EVICTION_RUNS_MILLIS, String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        reference.add(new StringRefAddr(KEY_MIN_EVICTABLE_IDLE_DURATION, String.valueOf(this.getMinEvictableIdleDuration())));
        reference.add(new StringRefAddr(KEY_MIN_EVICTABLE_IDLE_TIME_MILLIS, String.valueOf(this.getMinEvictableIdleTimeMillis())));
        return reference;
    }

    private String getStringContent(RefAddr refAddr) {
        return refAddr.getContent().toString();
    }

    @Deprecated
    public long getTimeBetweenEvictionRunsMillis() {
        return this.durationBetweenEvictionRuns.toMillis();
    }

    public String getUrl() {
        return this.connectionString;
    }

    public String getUser() {
        return this.userName;
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    private boolean isNotEmpty(RefAddr refAddr) {
        return refAddr != null && refAddr.getContent() != null;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void setConnectionProperties(Properties properties) {
        this.assertInitializationAllowed();
        this.connectionProperties = properties;
        if (this.connectionProperties != null) {
            String string;
            String string2 = this.connectionProperties.getProperty("user");
            if (string2 != null) {
                this.setUser(string2);
            }
            if ((string = this.connectionProperties.getProperty("password")) != null) {
                this.setPassword(string);
            }
        }
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDriver(String string) throws ClassNotFoundException {
        this.assertInitializationAllowed();
        this.driver = string;
        Class.forName(string);
    }

    public void setDurationBetweenEvictionRuns(Duration duration) {
        this.assertInitializationAllowed();
        this.durationBetweenEvictionRuns = duration;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.maxIdle = n;
    }

    public void setMaxPreparedStatements(int n) {
        this.maxPreparedStatements = n;
    }

    public void setMinEvictableIdleDuration(Duration duration) {
        this.assertInitializationAllowed();
        this.minEvictableIdleDuration = duration;
    }

    @Deprecated
    public void setMinEvictableIdleTimeMillis(int n) {
        this.assertInitializationAllowed();
        this.minEvictableIdleDuration = Duration.ofMillis(n);
    }

    public void setNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this.numTestsPerEvictionRun = n;
    }

    public void setPassword(char[] cArray) {
        this.assertInitializationAllowed();
        this.userPassword = Utils.clone(cArray);
        this.update(this.connectionProperties, "password", Utils.toString(this.userPassword));
    }

    public void setPassword(String string) {
        this.assertInitializationAllowed();
        this.userPassword = Utils.toCharArray(string);
        this.update(this.connectionProperties, "password", string);
    }

    public void setPoolPreparedStatements(boolean bl) {
        this.assertInitializationAllowed();
        this.poolPreparedStatements = bl;
    }

    @Deprecated
    public void setTimeBetweenEvictionRunsMillis(long l) {
        this.assertInitializationAllowed();
        this.durationBetweenEvictionRuns = Duration.ofMillis(l);
    }

    public void setUrl(String string) {
        this.assertInitializationAllowed();
        this.connectionString = string;
    }

    public void setUser(String string) {
        this.assertInitializationAllowed();
        this.userName = string;
        this.update(this.connectionProperties, "user", string);
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[description=");
        stringBuilder.append(this.description);
        stringBuilder.append(", connectionString=");
        stringBuilder.append(this.connectionString);
        stringBuilder.append(", driver=");
        stringBuilder.append(this.driver);
        stringBuilder.append(", loginTimeout=");
        stringBuilder.append(this.loginTimeout);
        stringBuilder.append(", poolPreparedStatements=");
        stringBuilder.append(this.poolPreparedStatements);
        stringBuilder.append(", maxIdle=");
        stringBuilder.append(this.maxIdle);
        stringBuilder.append(", timeBetweenEvictionRunsMillis=");
        stringBuilder.append(this.durationBetweenEvictionRuns);
        stringBuilder.append(", numTestsPerEvictionRun=");
        stringBuilder.append(this.numTestsPerEvictionRun);
        stringBuilder.append(", minEvictableIdleTimeMillis=");
        stringBuilder.append(this.minEvictableIdleDuration);
        stringBuilder.append(", maxPreparedStatements=");
        stringBuilder.append(this.maxPreparedStatements);
        stringBuilder.append(", getConnectionCalled=");
        stringBuilder.append(this.getConnectionCalled);
        stringBuilder.append(", connectionProperties=");
        stringBuilder.append(Utils.cloneWithoutCredentials(this.connectionProperties));
        stringBuilder.append(", accessToUnderlyingConnectionAllowed=");
        stringBuilder.append(this.accessToUnderlyingConnectionAllowed);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void update(Properties properties, String string, String string2) {
        if (properties != null && string != null) {
            if (string2 == null) {
                properties.remove(string);
            } else {
                properties.setProperty(string, string2);
            }
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

